define([
    'underscore',
    'Vent',
    'modules/community-care-request/view/community-care-view',
    'modules/new-appointment-wizard/wizard-step-model',
    'modules/new-appointment-request/views/requests/date-time/layout-view',
    'modules/community-care-request/new-appointment-request-question/notification-selection/community-care-notification-settings-layout-view', // eslint-disable-line max-len
    'modules/community-care-request/new-appointment-request-question/preferred-provider/preferred-provider-layout-view', // eslint-disable-line max-len
    'text!modules/community-care-request/new-appointment-request-question/request-preferences/community-care-appointment-preferences-layout.html', // eslint-disable-line max-len
],
function(
    _,
    vent,
    CommunityCareView,
    WizardStepModel,
    DateTimeLayoutView,
    CCNotificationSettingsLayout,
    PrimaryCareLayoutView,
    template
) {
    'use strict';

    // TODO make a Wizard Page Layout View that
    // - this can extend to make some methods such as declaimFDNS   trols,
    //   disableContinue, enableContinue, showPrevious DRY
    return CommunityCareView.extend({
        className: 'view',
        template: _.template(template),
        regions: {
            appointmentRequestPreferences: '.appointment-request-preferences',
        },
        events: _.extend({}, CommunityCareView.prototype.events, {
            'blur #optionDate1': 'handleModelChange',
            'blur #optionDate2': 'handleModelChange',
            'blur #optionDate3': 'handleModelChange',
        }),
        initialize: function(options) {
            if (_.isUndefined(options)) {
                this.model = new WizardStepModel.Model();
            } else {
                this.model = options.model;
                this.validator = options.validator;
                this.isValid = options.isValid;
            }
        },
        onRender: function() {
            this.showRegions();
        },
        onDomRefresh: function() {
            this.validateOptionDates();
            // we initialize a handle to the buttons and disable

            // if all the required fields are met, we enable
            this.handleModelChange();
        },

        showRegions: function() {
            this.showChildView('appointmentRequestPreferences', new DateTimeLayoutView({model: this.model}));
        },
        validateOptionDates: function() {
            _.each(this.model.attributes, function(value, key) {
                if (_.includes(key, 'optionDate') && value) {
                    this.$el.find('#' + key).valid();
                }
            }.bind(this));
        },
        toContinue: function(e) {
            if (this.isValid()) {
                this.checkTypeofCare();
            }
        },
        checkTypeofCare: function() {
            if (this.model.get('careTypeName') !== 'Primary Care (find a provider)') {
                vent.trigger('show:nextWizardPage', PrimaryCareLayoutView, 1);
            } else {
                vent.trigger('show:nextWizardPage', CCNotificationSettingsLayout, 1);
            }
        },
    });
});
